*****************************************************
// Data Preparation
*****************************************************

* NDHS 2017 
use "$ndhsfolder\PH_2017\PHPR70FL.dta", clear
  keep hhid sh208a-sh218x  
  rename sh208a sh208
  gen hvidx = sh208
  duplicates drop hhid hvidx if hvidx<., force
  drop if hvidx == .
  tempfile sec2a
    save `sec2a', replace
use "$ndhsfolder\PH_2017\PHPR70FL.dta", clear
  keep hhid sh222a-sh233z
  rename sh222a sh222
  gen hvidx = sh222
  duplicates drop hhid hvidx if hvidx<., force
  drop if hvidx == .
  tempfile sec2b
    save `sec2b', replace
use "$ndhsfolder\PH_2017\PHPR70FL.dta", clear
  keep hhid sh203a-sh204m 
  rename sh203a sh203
  gen hvidx = sh203
  duplicates drop hhid hvidx if hvidx<., force
  drop if hvidx == .
  tempfile sec2c
    save `sec2c', replace
use "$ndhsfolder\PH_2017\PHPR70FL.dta", clear
  drop sh203a-sh204m sh208a-sh218x sh222a-sh233z
  merge 1:1 hhid hvidx using `sec2a', nogen
  merge 1:1 hhid hvidx using `sec2b', nogen
  merge 1:1 hhid hvidx using `sec2c', nogen
	
  gen year=2017
  gen phicmem = inlist(1, sh09ba, sh09bb, sh09bc, sh09bd, sh09be, sh09bf, sh09bg)
  recode sh204a* (. = 0)
  ren sh204aa ill_diabetes
  ren sh204ab ill_cancer
  ren sh204ac ill_hypertension
  ren sh204ad ill_tuberculosis
  ren sh204ae ill_acyterespinf
  ren sh204af ill_acutegastroe
  ren sh204ag ill_colds
  ren sh204ah ill_wounds
  ren sh204ai ill_burn
  ren sh204aj ill_fracture
  ren sh204ak ill_dislocation
  ren sh204al ill_surgery
  ren sh204ao ill_diarrhea
  ren sh204au ill_dengue
  gen ill_others = inlist(1, sh204am, sh204an, sh204ap, sh204aq, sh204ar, sh204as, ///
     sh204at, sh204av, sh204aw, sh204ax)
  recode sh217a sh217b sh231a sh231b sh232b (999990 / 999999 = .)
  egen sh217n = rowtotal(sh217a sh217b) 
    replace sh217n = . if (sh217a==.)*(sh217b==.)
  egen sh231n = rowtotal(sh231a sh231b) 
    replace sh231n = . if (sh231a==.)*(sh231b==.)
	
  
  recode sh223 (21 22 23 24 25 = 1) (31 32 33 96 = 2) (98=.), gen(iptype)

  tempfile ndhs2017
    save `ndhs2017', replace
	
	
* NDHS 2013	
use "$ndhsfolder\PH_2013\PHPR62FL.dta", clear
  gen year=2013
  gen phicmem = inlist(1, sh111a, sh111b, sh111c, sh111d)
  recode sh204a* (. = 0)
  ren sh204a ill_diabetes
  ren sh204b ill_cancer
  ren sh204c ill_hypertension
  ren sh204d ill_tuberculosis
  ren sh204e ill_acyterespinf
  ren sh204f ill_acutegastroe
  ren sh204g ill_colds
  ren sh204h ill_wounds
  ren sh204i ill_burn
  ren sh204j ill_fracture
  ren sh204k ill_dislocation
  ren sh204l ill_surgery
  ren sh204m ill_diarrhea
  ren sh204n ill_dengue
  gen ill_others = inlist(1, sh204o, sh204p, sh204q, sh204x)
  recode sh217n sh231n (999990 / 999999 = .)
  assert (sh203==hvidx) if (sh203 < .)
  assert (sh208==hvidx) if (sh208 < .)
  assert (sh222==hvidx) if (sh222 < .)

recode sh223 (10 11 12 13 14 15 = 1) (20 21 22 23 96 = 2) (98=.), gen(iptype)
	
* Append NDHS 2017 to NDHS 2013  
append using `ndhs2017', force

foreach ill in diabetes cancer hypertension tuberculosis acyterespinf acutegastroe colds wounds burn fracture dislocation surgery diarrhea dengue {
	g ill_`ill'1=ill_`ill'
	replace ill_`ill'1=0 if ill_`ill'==. & year==2013
}

g ill_chronic=ill_diabetes1+ill_cancer1+ill_hypertension1
g ill_acute=ill_tuberculosis1+ill_acyterespinf1+ill_acutegastroe1+ill_colds1+ill_diarrhea1+ill_dengue1
g ill_acc=ill_wounds1 + ill_burn1 + ill_fracture1 + ill_dislocation1 

* Generate additional variables
recode hv106 (8 = .) (0=1), gen(hgc1) /*primary or lower, secondary, higher*/
recode hv109 (0 1 = 1) (2 3 = 2) (4 5 = 3) (8=.), gen(hgc)
recode hv104 (2 = 0), gen(male)
rename hv104 sex
recode hv105 (96 = 95) (98 = .), gen(age)
recode hv270 (1/2 = 1) (3/4 = 2) (5 = 3), gen(incg)
  *label val ses ses
  *label def ses 1 "Low" 2 "Middle" 3 "High" 
recode hv270 (1/2 = 1) (3  = 2) (4/5 = 3), gen(ses) /*switched ses & incg back to original on 2/22/2019*/

gen msick = (sh203==hvidx)
  label var msick "Got sick in past 30 days"
gen mvisit = (sh208==hvidx)
  label var mvisit "Visited health facility in past 30 days"
 recode sh212 (8 = .), gen(mconfined)

gen yconfined = (sh222==hvidx)
  label var yconfined "Confined in hospital in past year"

gen D  = (age >= 60)
gen y2017 = (year==2017)
gen D_y2017 = D*y2017
forval lll = 1/5 {
  gen X`lll' = (age - 60)^`lll'
  gen D_X`lll' = D*(age - 60)^`lll'
  gen D_y2017_X`lll' = D*y2017*(age - 60)^`lll'
 }

replace hhid = string(year) + hhid

g yr=year==2017 if year<.
gen D_after=D_y2017

xi i.hgc i.incg, prefix(d) noomit

**Corresponds to AT
g categ=1 if (age<60|yr==0) & phicmem==1
**Corresponds to AT+TC
replace categ=2 if age>=60 & phicmem==1 & yr==1
**Corresponds to NT+UC
replace categ=3 if (age<60|yr==0) & phicmem==0
**Corresponds to NT 
replace categ=4 if age>=60 & phicmem==0 & yr==1
label define categ 1 "AlwaysTakers"  2 "AT+TComp" 3 "NT+UComp" 4 "NeverTakers"
label values categ "categ"

g regn=shregion
replace regn=hv024 if regn==.
replace regn=41 if regn==4
replace regn=42 if regn==17
label drop SHREGION

recode regn (1 2 3 5 13 14 41 42 = 1) (6 7 8=2) (9 10 11 12 13 15 16 = 3), gen(isl)
save "$data\ndhsfile", replace

